unit dirscan1;

interface

uses
  Winprocs,WinTypes, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,TDirScan;

type


  TForm1 = class(TForm)
    Button1: TButton;
    filelist: TListBox;
    path: TEdit;
    dirlist: TListBox;
    wildcard: TEdit;
    progress: TLabel;
    Button2: TButton;
    pathlist: TListBox;
    DirectoryScan1: TDirectoryScan;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure DirectoryScan1Progress(Sender: TObject);
    procedure DirectoryScan1DirList(Sender: TObject; paths: TStrings);
    procedure DirectoryScan1File(Sender : TObject;path : String);
    procedure DirectoryScan1Directory(Sender : TObject;path : String);
    procedure DirectoryScan1VerifyFile(Sender: TObject; path: string;
      stream: TFileStream; TimeStamp: TDateTime; var PassFlag: Boolean);
    procedure CheckBox1Click(Sender: TObject);
  private
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.DirectoryScan1Directory(Sender : TObject;path : String);
Begin
   dirlist.items.Add(path);
End;

procedure TForm1.DirectoryScan1File(Sender : TObject;path : String);
Begin
   filelist.items.Add(path);
End;

procedure TForm1.Button1Click(Sender: TObject);
var oldcap : String;
begin
   oldcap := Caption;
   Caption := 'SCANNING... PLEASE WAIT!';
   Button1.Enabled := False;
   dirlist.items.Clear;
   filelist.items.Clear;
   pathlist.items.Clear;
   DirectoryScan1.Directory := path.Text;
   DirectoryScan1.FileName := wildcard.Text;
   DirectoryScan1.Subdirectories := Checkbox2.Checked;
   if not DirectoryScan1.Execute then
      ShowMessage('No files found or an error occurred.');
   Button1.Enabled := True;
   Caption := oldcap;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   DirectoryScan1.Cancel;
end;

procedure TForm1.DirectoryScan1Progress(Sender: TObject);
begin
   progress.Caption := 'Files: ' + IntToStr(DirectoryScan1.TotalCount) + ' ' + DirectoryScan1.CurDirectory;
end;

procedure TForm1.DirectoryScan1DirList(Sender: TObject; paths: TStrings);
begin
   pathlist.items.Assign(paths);
end;

procedure TForm1.DirectoryScan1VerifyFile(Sender: TObject; path: string;
  stream: TFileStream; TimeStamp: TDateTime; var PassFlag: Boolean);
begin
   PassFlag := (TimeStamp >= Now - 5.0);
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
   if Checkbox1.Checked then
      DirectoryScan1.OnVerifyFile := DirectoryScan1VerifyFile
   else
      DirectoryScan1.OnVerifyFile := nil;
end;

end.
